/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public abstract class SpringTestSupport
extends ContextTestSupport {
    protected AbstractXmlApplicationContext applicationContext;

    protected abstract AbstractXmlApplicationContext createApplicationContext();

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        SpringTestSupport.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    protected ApplicationContext getRouteExcludingApplicationContext() {
        GenericApplicationContext routeExcludingContext = new GenericApplicationContext();
        routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
        routeExcludingContext.refresh();
        ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)((Object)routeExcludingContext.getBean("excludingResolver"));
        List excluded = CastUtils.cast(Arrays.asList(this.excludeRoutes()));
        excludingResolver.setExcludedClasses(new HashSet(excluded));
        return routeExcludingContext;
    }

    protected Class<?>[] excludeRoutes() {
        Class[] classArray;
        Class<?> excludedRoute = this.excludeRoute();
        if (excludedRoute != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = excludedRoute;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    protected Class<?> excludeRoute() {
        return null;
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        SpringTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        SpringTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className((Object)value)));
        return null;
    }

    protected void assertValidContext(CamelContext context) {
        super.assertValidContext(context);
        List routes = context.getRoutes();
        int routeCount = this.getExpectedRouteCount();
        if (routeCount > 0) {
            SpringTestSupport.assertNotNull((String)"Should have some routes defined", (Object)routes);
            SpringTestSupport.assertTrue((String)"Should have at least one route", (routes.size() >= routeCount ? 1 : 0) != 0);
        }
        this.log.debug("Camel Routes: " + routes);
    }

    protected int getExpectedRouteCount() {
        return 1;
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
    }

    private static class ExcludingPackageScanClassResolver
    extends DefaultPackageScanClassResolver {
        private ExcludingPackageScanClassResolver() {
        }

        public void setExcludedClasses(Set<Class<?>> excludedClasses) {
            if (excludedClasses == null) {
                excludedClasses = CastUtils.cast(Collections.emptySet());
            }
            this.addFilter((PackageScanFilter)new InvertingPackageScanFilter((PackageScanFilter)new AssignableToPackageScanFilter(excludedClasses)));
        }
    }
}

