/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.EventObject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.management.EventNotifierSupport;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStoppingEvent;

public class StartAndStopEventNotifier
extends EventNotifierSupport
implements CamelContextAware {
    private CamelContext camelContext;
    private ProducerTemplate template;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void notify(EventObject event) throws Exception {
        if (event instanceof CamelContextStartedEvent) {
            this.log.info("Sending a message on startup...");
            this.template.sendBody("file:target/startandstop/start.txt", (Object)"Starting");
        } else if (event instanceof CamelContextStoppingEvent) {
            this.log.info("Sending a message on stopping...");
            this.template.sendBody("file:target/startandstop/stop.txt", (Object)"Stopping");
        }
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    protected void doStart() throws Exception {
        this.template = this.camelContext.createProducerTemplate();
        this.template.start();
    }

    protected void doStop() throws Exception {
        this.template.stop();
    }
}

