/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.aop;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.aop.ExceptionInterceptor;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringAopClassLevelCamelBeanTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/aop/SpringAopClassLevelCamelBeanTest.xml");
    }

    public void testSpringAopOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    public void testSpringAopException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"Damn");
            SpringAopClassLevelCamelBeanTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            SpringAopClassLevelCamelBeanTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
        }
        this.assertMockEndpointsSatisfied();
        ExceptionInterceptor ei = (ExceptionInterceptor)this.context.getRegistry().lookup("exceptionInterceptor", ExceptionInterceptor.class);
        IllegalArgumentException iae = (IllegalArgumentException)SpringAopClassLevelCamelBeanTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)ei.getE());
        SpringAopClassLevelCamelBeanTest.assertEquals((String)"Foo has not expected value ABC but Damn", (String)iae.getMessage());
    }
}

