/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.bind;

import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spring.bind.ExampleBean;

public class BeanInfoTest
extends TestCase {
    protected DefaultCamelContext camelContext = new DefaultCamelContext();
    protected Exchange exchange = new DefaultExchange((CamelContext)this.camelContext);
    protected DefaultParameterMappingStrategy strategy = new DefaultParameterMappingStrategy();
    protected ExampleBean bean = new ExampleBean();
    protected BeanInfo info;

    public void testFindsSingleMethodMatchingBody() throws Throwable {
        MethodInvocation invocation = this.info.createInvocation((Object)this.bean, this.exchange);
        BeanInfoTest.assertNotNull((String)"Should have found a method invocation!", (Object)invocation);
        AtomicBoolean sync = new AtomicBoolean(true);
        Object value = invocation.proceed(new AsyncCallback(){

            public void done(boolean doneSync) {
            }
        }, sync);
        BeanInfoTest.assertEquals((boolean)true, (boolean)sync.get());
        BeanInfoTest.assertEquals((Object)"Hello James!", (Object)value);
    }

    public void testBeanProcessor() throws Exception {
        BeanProcessor processor = new BeanProcessor((Object)this.bean, this.info);
        processor.process(this.exchange);
        BeanInfoTest.assertEquals((Object)"Hello James!", (Object)this.exchange.getIn().getBody());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exchange.getIn().setBody((Object)"James");
        this.info = new BeanInfo((CamelContext)this.camelContext, this.bean.getClass(), (ParameterMappingStrategy)this.strategy);
    }
}

