/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.bind;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.bind.ProcessorStub;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ProcessorAsEndpointTest
extends SpringTestSupport {
    protected Object body = "<hello>world!</hello>";

    public void testSendingToProcessorEndpoint() throws Exception {
        ProcessorStub processor = this.getMandatoryBean(ProcessorStub.class, "myProcessor");
        this.template.sendBody("myProcessor", this.body);
        List<Exchange> list = processor.getExchanges();
        ProcessorAsEndpointTest.assertEquals((String)("Received exchange list: " + list), (int)1, (int)list.size());
        this.log.debug("Found exchanges: " + list);
    }

    public void testSendingToNonExistentEndpoint() throws Exception {
        String uri = "unknownEndpoint";
        Endpoint endpoint = this.context.getEndpoint(uri);
        ProcessorAsEndpointTest.assertNull((String)("Should not have found an endpoint! Was: " + endpoint), (Object)endpoint);
        try {
            this.template.sendBody(uri, this.body);
            ProcessorAsEndpointTest.fail((String)"We should have failed as this is a bad endpoint URI");
        }
        catch (NoSuchEndpointException e) {
            this.log.debug("Caught expected exception: " + (Object)((Object)e), (Throwable)e);
        }
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/bind/processorAsEndpoint.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }
}

