/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import junit.framework.TestCase;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelContextAutoStartupTest
extends TestCase {
    private AbstractXmlApplicationContext ac;

    public void testAutoStartupFalse() throws Exception {
        this.ac = new ClassPathXmlApplicationContext("org/apache/camel/spring/config/CamelContextAutoStartupTestFalse.xml");
        SpringCamelContext camel = (SpringCamelContext)this.ac.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        CamelContextAutoStartupTest.assertNotNull((Object)camel.getName());
        CamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        CamelContextAutoStartupTest.assertEquals((Object)Boolean.FALSE, (Object)camel.isAutoStartup());
        CamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        CamelContextAutoStartupTest.assertEquals((boolean)false, (boolean)camel.getRouteStatus("foo").isStarted());
        camel.startRoute("foo");
        CamelContextAutoStartupTest.assertEquals((Object)Boolean.FALSE, (Object)camel.isAutoStartup());
        CamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        CamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        ProducerTemplate template = camel.createProducerTemplate();
        template.start();
        template.sendBody("direct:start", (Object)"Hello World");
        template.stop();
        mock.assertIsSatisfied();
    }

    public void testAutoStartupTrue() throws Exception {
        this.ac = new ClassPathXmlApplicationContext("org/apache/camel/spring/config/CamelContextAutoStartupTestTrue.xml");
        SpringCamelContext camel = (SpringCamelContext)this.ac.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        CamelContextAutoStartupTest.assertNotNull((Object)camel.getName());
        CamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        CamelContextAutoStartupTest.assertEquals((Object)Boolean.TRUE, (Object)camel.isAutoStartup());
        CamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        ProducerTemplate template = camel.createProducerTemplate();
        template.start();
        template.sendBody("direct:start", (Object)"Hello World");
        template.stop();
        mock.assertIsSatisfied();
    }

    protected void tearDown() throws Exception {
        if (this.ac != null) {
            this.ac.close();
        }
        super.tearDown();
    }
}

