/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.config.XmlConfigTestSupport;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CamelContextFactoryBeanTest
extends XmlConfigTestSupport {
    protected void setUp() throws Exception {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("org.apache.camel.jmx.disabled");
    }

    public void testClassPathRouteLoading() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextFactoryBean.xml");
        CamelContext context = (CamelContext)applicationContext.getBean("camel");
        this.assertValidContext(context);
    }

    public void testClassPathRouteLoadingUsingNamespaces() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextFactoryBean.xml");
        CamelContext context = (CamelContext)applicationContext.getBean("camel3");
        this.assertValidContext(context);
    }

    public void testGenericApplicationContextUsingNamespaces() throws Exception {
        GenericApplicationContext applicationContext = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)applicationContext);
        xmlReader.loadBeanDefinitions((Resource)new ClassPathResource("org/apache/camel/spring/camelContextFactoryBean.xml"));
        applicationContext.refresh();
        CamelContext context = (CamelContext)applicationContext.getBean("camel3");
        this.assertValidContext(context);
    }

    public void testXMLRouteLoading() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextFactoryBean.xml");
        CamelContext context = (CamelContext)applicationContext.getBean("camel2");
        CamelContextFactoryBeanTest.assertNotNull((String)"No context found!", (Object)context);
        List routes = context.getRoutes();
        LOG.debug("Found routes: " + routes);
        CamelContextFactoryBeanTest.assertNotNull((String)"Should have found some routes", (Object)routes);
        CamelContextFactoryBeanTest.assertEquals((String)"One Route should be found", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            EventDrivenConsumerRoute consumerRoute = (EventDrivenConsumerRoute)CamelContextFactoryBeanTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, (Object)route);
            Processor processor = consumerRoute.getProcessor();
            CamelContextFactoryBeanTest.assertNotNull((Object)processor);
            CamelContextFactoryBeanTest.assertEndpointUri((Endpoint)key, (String)"seda://test.c");
        }
    }

    public void testRouteBuilderRef() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextRouteBuilderRef.xml");
        CamelContext context = (CamelContext)applicationContext.getBean("camel5");
        CamelContextFactoryBeanTest.assertNotNull((String)"No context found!", (Object)context);
        this.assertValidContext(context);
    }

    public void testAutoStartup() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextFactoryBean.xml");
        SpringCamelContext context = (SpringCamelContext)applicationContext.getBean("camel4");
        CamelContextFactoryBeanTest.assertFalse((boolean)context.isAutoStartup());
        CamelContextFactoryBeanTest.assertEquals((int)1, (int)context.getRoutes().size());
        context = (SpringCamelContext)applicationContext.getBean("camel3");
        CamelContextFactoryBeanTest.assertTrue((boolean)context.isAutoStartup());
        CamelContextFactoryBeanTest.assertEquals((int)1, (int)context.getRoutes().size());
    }
}

