/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.config.MyProxySender;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelProxyTest
extends TestCase {
    public void testCamelProxy() throws Exception {
        ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext("org/apache/camel/spring/config/CamelProxyTest.xml");
        MyProxySender sender = (MyProxySender)ac.getBean("myProxySender");
        String reply = sender.hello("World");
        CamelProxyTest.assertEquals((String)"Hello World", (String)reply);
        MyProxySender anotherSender = (MyProxySender)ac.getBean("myAnotherProxySender");
        SpringCamelContext context = (SpringCamelContext)ac.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        MockEndpoint result = (MockEndpoint)TestSupport.resolveMandatoryEndpoint((CamelContext)context, (String)"mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{"Hello my friends!"});
        anotherSender.greeting("Hello my friends!");
        result.assertIsSatisfied();
        result.reset();
        MyProxySender myProxySenderWithCamelContextId = (MyProxySender)ac.getBean("myProxySenderWithCamelContextId");
        result.expectedBodiesReceived(new Object[]{"Hello my friends again!"});
        myProxySenderWithCamelContextId.greeting("Hello my friends again!");
        result.assertIsSatisfied();
    }
}

