/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ConsumerTemplateAlreadyExistTest
extends AbstractJUnit38SpringContextTests {
    @Autowired
    private ConsumerTemplate template;
    @Autowired
    private CamelContext context;

    public void testHasExistingTemplate() {
        ConsumerTemplateAlreadyExistTest.assertNotNull((String)"Should have injected a consumer template", (Object)this.template);
        ConsumerTemplate lookup = (ConsumerTemplate)this.context.getRegistry().lookup("myConsumerTemplate", ConsumerTemplate.class);
        ConsumerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup consumer template", (Object)lookup);
        ConsumerTemplate lookup2 = (ConsumerTemplate)this.context.getRegistry().lookup("consumerTemplate", ConsumerTemplate.class);
        ConsumerTemplateAlreadyExistTest.assertNull((String)"Should not be able to lookup consumer template", (Object)lookup2);
    }

    public void testShouldBeSingleton() {
        ConsumerTemplate lookup = (ConsumerTemplate)this.context.getRegistry().lookup("myConsumerTemplate", ConsumerTemplate.class);
        ConsumerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ConsumerTemplate lookup2 = (ConsumerTemplate)this.context.getRegistry().lookup("myConsumerTemplate", ConsumerTemplate.class);
        ConsumerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ConsumerTemplateAlreadyExistTest.assertSame((String)"Should be same instances (singleton)", (Object)lookup, (Object)lookup2);
    }
}

