/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ConsumerTemplateMaximumCacheSizeTest
extends AbstractJUnit38SpringContextTests {
    @Autowired
    private ConsumerTemplate template;
    @Autowired
    private CamelContext context;

    public void testTemplateMaximumCache() throws Exception {
        ConsumerTemplateMaximumCacheSizeTest.assertNotNull((String)"Should have injected a consumer template", (Object)this.template);
        ConsumerTemplate lookup = (ConsumerTemplate)this.context.getRegistry().lookup("template", ConsumerTemplate.class);
        ConsumerTemplateMaximumCacheSizeTest.assertNotNull((String)"Should lookup consumer template", (Object)lookup);
        ConsumerTemplateMaximumCacheSizeTest.assertEquals((int)50, (int)this.template.getMaximumCacheSize());
        ConsumerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)this.template.getCurrentCacheSize());
        for (int i = 0; i < 53; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            this.template.receiveNoWait(e);
        }
        ConsumerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 50", (int)50, (int)this.template.getCurrentCacheSize());
        this.template.stop();
        ConsumerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)this.template.getCurrentCacheSize());
    }
}

