/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.config.TemplateUsingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class DependencyInjectCamelTemplateTest
extends AbstractJUnit38SpringContextTests {
    protected String body = "Hello";
    @Autowired
    private TemplateUsingBean bean;
    @EndpointInject(uri="mock:results")
    private MockEndpoint endpoint;

    public void testBeanHasCamelTemplateInjected() throws Exception {
        DependencyInjectCamelTemplateTest.assertNotNull((String)"Bean should be injected", (Object)this.bean);
        ProducerTemplate template = this.bean.getTemplate();
        DependencyInjectCamelTemplateTest.assertNotNull((String)"Bean should have a CamelTemplate", (Object)template);
        this.endpoint.expectedBodiesReceived(new Object[]{this.body});
        template.sendBody((Object)this.body);
        this.endpoint.assertIsSatisfied();
    }
}

