/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ErrorHandlerConfigTest
extends AbstractJUnit38SpringContextTests {
    @Autowired
    protected ProducerTemplate template;
    @Autowired
    protected CamelContext context;
    protected Object expectedBody = "<hello>world!</hello>";

    public void testRouteInheritsConfiguredErrorHandler() throws Exception {
        this.assertReceivedMessageWithErrorHandlerValue("defaultErrorHandler", "defaultErrorHandler");
    }

    public void testRouteConfiguredErrorHandler() throws Exception {
        this.assertReceivedMessageWithErrorHandlerValue("customErrorHandler", "customErrorHandler");
    }

    protected void assertReceivedMessageWithErrorHandlerValue(String name, String value) throws InterruptedException {
        this.template.sendBody("direct:" + name, this.expectedBody);
        MockEndpoint endpoint = MockEndpoint.resolve((CamelContext)this.context, (String)("mock:" + name));
        endpoint.expectedMessageCount(1);
        ((ValueBuilder)endpoint.message(0).header("DummyErrorHandler")).isEqualTo((Object)value);
        endpoint.assertIsSatisfied();
    }
}

