/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ErrorHandlerTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/errorHandler.xml");
    }

    public void testEndpointConfiguration() throws Exception {
        SpringCamelContext context = (SpringCamelContext)this.applicationContext.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        List list = context.getRoutes();
        ErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)2, (int)list.size());
        for (Route route : list) {
            EventDrivenConsumerRoute consumerRoute = (EventDrivenConsumerRoute)ErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, (Object)route);
            Channel channel = ErrorHandlerTest.unwrapChannel((Processor)consumerRoute.getProcessor());
            DeadLetterChannel deadLetterChannel = (DeadLetterChannel)ErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, (Object)channel.getErrorHandler());
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            ErrorHandlerTest.assertEquals((String)"getMaximumRedeliveries()", (int)1, (int)redeliveryPolicy.getMaximumRedeliveries());
            ErrorHandlerTest.assertEquals((String)"isUseExponentialBackOff()", (boolean)true, (boolean)redeliveryPolicy.isUseExponentialBackOff());
        }
    }
}

