/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OneRouteRefOnExceptionTest
extends SpringTestSupport {
    public void testOneRouteRefNoOnException() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:foo", (Object)"Hello World");
            OneRouteRefOnExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            OneRouteRefOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            OneRouteRefOnExceptionTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testOneRouteRefOnException() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/OneRouteRefOnException.xml");
    }
}

