/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ProducerTemplateAlreadyExistTest
extends AbstractJUnit38SpringContextTests {
    @Autowired
    private ProducerTemplate template;
    @Autowired
    private CamelContext context;

    public void testHasExistingTemplate() {
        ProducerTemplateAlreadyExistTest.assertNotNull((String)"Should have injected a producer template", (Object)this.template);
        ProducerTemplate lookup = (ProducerTemplate)this.context.getRegistry().lookup("myTemplate", ProducerTemplate.class);
        ProducerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplate lookup2 = (ProducerTemplate)this.context.getRegistry().lookup("template", ProducerTemplate.class);
        ProducerTemplateAlreadyExistTest.assertNull((String)"Should not be able to lookup producer template", (Object)lookup2);
    }

    public void testShouldBeSingleton() {
        ProducerTemplate lookup = (ProducerTemplate)this.context.getRegistry().lookup("myTemplate", ProducerTemplate.class);
        ProducerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplate lookup2 = (ProducerTemplate)this.context.getRegistry().lookup("myTemplate", ProducerTemplate.class);
        ProducerTemplateAlreadyExistTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplateAlreadyExistTest.assertSame((String)"Should be same instances (singleton)", (Object)lookup, (Object)lookup2);
    }
}

