/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ProducerTemplateAutoRegisterTwoCamelContextsTest
extends AbstractJUnit38SpringContextTests {
    @Resource(name="camel1")
    private CamelContext context1;
    @Resource(name="camel2")
    private CamelContext context2;

    public void testHasNoTemplateCamel1() {
        ProducerTemplate lookup = (ProducerTemplate)this.context1.getRegistry().lookup("template", ProducerTemplate.class);
        ProducerTemplateAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup producer template", (Object)lookup);
    }

    public void testHasNoTemplateCamel2() {
        ProducerTemplate lookup = (ProducerTemplate)this.context2.getRegistry().lookup("template", ProducerTemplate.class);
        ProducerTemplateAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup producer template", (Object)lookup);
    }

    public void testHasNoConsumerTemplateCamel1() {
        ConsumerTemplate lookup = (ConsumerTemplate)this.context1.getRegistry().lookup("consumerTemplate", ConsumerTemplate.class);
        ProducerTemplateAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup consumer template", (Object)lookup);
    }

    public void testHasNoConsumerTemplateCamel2() {
        ConsumerTemplate lookup = (ConsumerTemplate)this.context2.getRegistry().lookup("consumerTemplate", ConsumerTemplate.class);
        ProducerTemplateAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup consumer template", (Object)lookup);
    }
}

