/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ProducerTemplateMaximumCacheSizeTest
extends AbstractJUnit38SpringContextTests {
    @Autowired
    private ProducerTemplate template;
    @Autowired
    private CamelContext context;

    public void testTemplateMaximumCache() throws Exception {
        ProducerTemplateMaximumCacheSizeTest.assertNotNull((String)"Should have injected a producer template", (Object)this.template);
        ProducerTemplate lookup = (ProducerTemplate)this.context.getRegistry().lookup("template", ProducerTemplate.class);
        ProducerTemplateMaximumCacheSizeTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplateMaximumCacheSizeTest.assertEquals((int)50, (int)this.template.getMaximumCacheSize());
        ProducerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)this.template.getCurrentCacheSize());
        for (int i = 0; i < 53; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            this.template.sendBody(e, (Object)"Hello");
        }
        ProducerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 50", (int)50, (int)this.template.getCurrentCacheSize());
        this.template.stop();
        ProducerTemplateMaximumCacheSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)this.template.getCurrentCacheSize());
    }
}

