/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class ProducerTemplateMixedAutoRegisterTwoCamelContextsTest
extends AbstractJUnit38SpringContextTests {
    @Resource(name="camel1")
    private CamelContext context1;
    @Resource(name="camel2")
    private CamelContext context2;

    public void testHasTemplateCamel1() {
        DefaultProducerTemplate lookup = (DefaultProducerTemplate)this.context1.getRegistry().lookup("template1", DefaultProducerTemplate.class);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertEquals((String)"camel1", (String)lookup.getContext().getName());
    }

    public void testHasTemplateCamel2() {
        DefaultProducerTemplate lookup = (DefaultProducerTemplate)this.context1.getRegistry().lookup("template2", DefaultProducerTemplate.class);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertNotNull((String)"Should lookup producer template", (Object)lookup);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertEquals((String)"camel2", (String)lookup.getContext().getName());
    }

    public void testHasNoConsumerTemplateCamel1() {
        ConsumerTemplate lookup = (ConsumerTemplate)this.context1.getRegistry().lookup("consumerTemplate", ConsumerTemplate.class);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup consumer template", (Object)lookup);
    }

    public void testHasNoConsumerTemplateCamel2() {
        ConsumerTemplate lookup = (ConsumerTemplate)this.context2.getRegistry().lookup("consumerTemplate", ConsumerTemplate.class);
        ProducerTemplateMixedAutoRegisterTwoCamelContextsTest.assertNull((String)"Should NOT lookup consumer template", (Object)lookup);
    }
}

