/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RouteRefMultipleCamelContextRefsTest
extends TestCase {
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/RouteRefMultipleCamelContextRefsTest.xml");
    }

    public void testSpringTwoCamelContextDirectEndpoint() throws Exception {
        AbstractXmlApplicationContext ac = this.createApplicationContext();
        ac.start();
        CamelContext camel1 = (CamelContext)ac.getBean("myCamel-1", CamelContext.class);
        CamelContext camel2 = (CamelContext)ac.getBean("myCamel-2", CamelContext.class);
        Endpoint start1 = camel1.getEndpoint("direct:start");
        Endpoint start2 = camel2.getEndpoint("direct:start");
        RouteRefMultipleCamelContextRefsTest.assertNotSame((Object)start1, (Object)start2);
        MockEndpoint mock1 = (MockEndpoint)camel1.getEndpoint("mock:result", MockEndpoint.class);
        mock1.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint mock2 = (MockEndpoint)camel2.getEndpoint("mock:result", MockEndpoint.class);
        mock2.expectedBodiesReceived(new Object[]{"Bye World"});
        camel1.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        camel2.createProducerTemplate().sendBody("direct:start", (Object)"Bye World");
        mock1.assertIsSatisfied();
        mock2.assertIsSatisfied();
        ac.stop();
    }
}

