/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContextCustomDefaultThreadPoolProfileTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/SpringCamelContextCustomDefaultThreadPoolProfileTest.xml");
    }

    public void testDefaultThreadPoolProfile() throws Exception {
        SpringCamelContext context = (SpringCamelContext)this.applicationContext.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        ThreadPoolProfile profile = context.getExecutorServiceStrategy().getDefaultThreadPoolProfile();
        SpringCamelContextCustomDefaultThreadPoolProfileTest.assertEquals((int)5, (int)profile.getPoolSize());
        SpringCamelContextCustomDefaultThreadPoolProfileTest.assertEquals((int)15, (int)profile.getMaxPoolSize());
        SpringCamelContextCustomDefaultThreadPoolProfileTest.assertEquals((long)25L, (long)profile.getKeepAliveTime());
        SpringCamelContextCustomDefaultThreadPoolProfileTest.assertEquals((int)250, (int)profile.getMaxQueueSize());
        SpringCamelContextCustomDefaultThreadPoolProfileTest.assertEquals((Object)ThreadPoolRejectedPolicy.Abort, (Object)profile.getRejectedPolicy());
    }
}

