/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContextCustomThreadPoolProfileTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/SpringCamelContextCustomThreadPoolProfileTest.xml");
    }

    public void testDefaultThreadPoolProfile() throws Exception {
        CamelContext context = this.getMandatoryBean(CamelContext.class, "camel-D");
        ThreadPoolProfile profile = context.getExecutorServiceStrategy().getDefaultThreadPoolProfile();
        SpringCamelContextCustomThreadPoolProfileTest.assertEquals((int)5, (int)profile.getPoolSize());
        SpringCamelContextCustomThreadPoolProfileTest.assertEquals((int)15, (int)profile.getMaxPoolSize());
        SpringCamelContextCustomThreadPoolProfileTest.assertEquals((long)25L, (long)profile.getKeepAliveTime());
        SpringCamelContextCustomThreadPoolProfileTest.assertEquals((int)250, (int)profile.getMaxQueueSize());
        SpringCamelContextCustomThreadPoolProfileTest.assertEquals((Object)ThreadPoolRejectedPolicy.Abort, (Object)profile.getRejectedPolicy());
    }
}

