/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.xml");
    }

    public void testDefaultThreadPoolProfile() throws Exception {
        CamelContext context = this.getMandatoryBean(CamelContext.class, "camel-B");
        ThreadPoolProfile profile = context.getExecutorServiceStrategy().getDefaultThreadPoolProfile();
        SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.assertEquals((int)25, (int)profile.getMaxPoolSize());
        SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.assertEquals((int)10, (int)profile.getPoolSize());
        SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.assertEquals((long)60L, (long)profile.getKeepAliveTime());
        SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.assertEquals((int)1000, (int)profile.getMaxQueueSize());
        SpringCamelContextSimpleCustomDefaultThreadPoolProfileTest.assertEquals((Object)ThreadPoolRejectedPolicy.CallerRuns, (Object)profile.getRejectedPolicy());
    }
}

