/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContextThreadPoolProfilesTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/SpringCamelContextThreadPoolProfilesTest.xml");
    }

    public void testLowProfile() throws Exception {
        CamelContext context = this.getMandatoryBean(CamelContext.class, "camel-C");
        ThreadPoolProfile profile = context.getExecutorServiceStrategy().getThreadPoolProfile("low");
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)1, (int)profile.getPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)5, (int)profile.getMaxPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals(null, (Object)profile.getKeepAliveTime());
        SpringCamelContextThreadPoolProfilesTest.assertEquals(null, (Object)profile.getMaxQueueSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals(null, (Object)profile.getRejectedPolicy());
        ExecutorService executor = context.getExecutorServiceStrategy().newThreadPool((Object)this, "MyLow", "low");
        ThreadPoolExecutor tp = (ThreadPoolExecutor)SpringCamelContextThreadPoolProfilesTest.assertIsInstanceOf(ThreadPoolExecutor.class, (Object)executor);
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)5, (int)tp.getMaximumPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        SpringCamelContextThreadPoolProfilesTest.assertIsInstanceOf(ThreadPoolExecutor.CallerRunsPolicy.class, (Object)tp.getRejectedExecutionHandler());
    }

    public void testBigProfile() throws Exception {
        CamelContext context = this.getMandatoryBean(CamelContext.class, "camel-C");
        ThreadPoolProfile profile = context.getExecutorServiceStrategy().getThreadPoolProfile("big");
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)50, (int)profile.getPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)100, (int)profile.getMaxPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((Object)ThreadPoolRejectedPolicy.DiscardOldest, (Object)profile.getRejectedPolicy());
        SpringCamelContextThreadPoolProfilesTest.assertEquals(null, (Object)profile.getKeepAliveTime());
        SpringCamelContextThreadPoolProfilesTest.assertEquals(null, (Object)profile.getMaxQueueSize());
        ExecutorService executor = context.getExecutorServiceStrategy().newThreadPool((Object)this, "MyBig", "big");
        ThreadPoolExecutor tp = (ThreadPoolExecutor)SpringCamelContextThreadPoolProfilesTest.assertIsInstanceOf(ThreadPoolExecutor.class, (Object)executor);
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)50, (int)tp.getCorePoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((int)100, (int)tp.getMaximumPoolSize());
        SpringCamelContextThreadPoolProfilesTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        SpringCamelContextThreadPoolProfilesTest.assertIsInstanceOf(ThreadPoolExecutor.DiscardOldestPolicy.class, (Object)tp.getRejectedExecutionHandler());
    }
}

