/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringErrorHandlerConfigTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/SpringErrorHandlerConfigTest.xml");
    }

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:dlc").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testDLC() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dlc").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    public void testDefaultEH() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dlc").expectedMessageCount(0);
        Exchange exchange = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Damn");
            }
        });
        this.assertMockEndpointsSatisfied();
        SpringErrorHandlerConfigTest.assertTrue((boolean)exchange.isFailed());
        SpringErrorHandlerConfigTest.assertEquals((String)"Damn cannot do this", (String)((IllegalArgumentException)exchange.getException(IllegalArgumentException.class)).getMessage());
        SpringErrorHandlerConfigTest.assertEquals((Object)true, (Object)exchange.getIn().getHeader("CamelRedelivered"));
        SpringErrorHandlerConfigTest.assertEquals((Object)2, (Object)exchange.getIn().getHeader("CamelRedeliveryCounter"));
    }
}

