/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TwoRouteRefOnExceptionTest
extends SpringTestSupport {
    public void testTwoRouteRefNoOnException() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:foo", (Object)"Hello World");
            TwoRouteRefOnExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            TwoRouteRefOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            TwoRouteRefOnExceptionTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testTwoRouteRefOnException() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/config/TwoRouteRefOnException.xml");
    }
}

