/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.config.CamelContextFactoryBeanTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigTestSupport
extends TestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBeanTest.class);

    protected void assertValidContext(CamelContext context) {
        XmlConfigTestSupport.assertNotNull((String)"No context found!", (Object)context);
        List routes = context.getRouteDefinitions();
        LOG.debug("Found routes: " + routes);
        XmlConfigTestSupport.assertEquals((String)"One Route should be found", (int)1, (int)routes.size());
        for (RouteDefinition route : routes) {
            List inputs = route.getInputs();
            XmlConfigTestSupport.assertEquals((String)"Number of inputs", (int)1, (int)inputs.size());
            FromDefinition fromType = (FromDefinition)inputs.get(0);
            XmlConfigTestSupport.assertEquals((String)"from URI", (String)"seda:test.a", (String)fromType.getUri());
            List outputs = route.getOutputs();
            XmlConfigTestSupport.assertEquals((String)"Number of outputs", (int)1, (int)outputs.size());
        }
    }
}

