/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config.scan;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.config.scan.route.MyExcludedRouteBuilder;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RouteExclusionFromWithinSpringTestSupportTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext(new String[]{"org/apache/camel/spring/config/scan/componentScan.xml"}, this.getRouteExcludingApplicationContext());
    }

    public void testRouteExcluded() throws InterruptedException {
        RouteExclusionFromWithinSpringTestSupportTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        MockEndpoint mock = this.getMockEndpoint("mock:definitelyShouldNeverReceiveExchange");
        mock.expectedMessageCount(0);
        this.sendBody("direct:shouldNeverRecieveExchange", "dropped like a hot rock");
        mock.await(500L, TimeUnit.MILLISECONDS);
        mock.assertIsSatisfied();
    }

    public void testRoutesNotExcludedWorkNormally() throws InterruptedException {
        this.template.sendBody("direct:start", (Object)"request");
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        mock.assertIsSatisfied();
    }

    @Override
    protected Class<?> excludeRoute() {
        return MyExcludedRouteBuilder.class;
    }
}

