/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config.scan;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringComponentScanTest
extends ContextTestSupport {
    protected void setUp() throws Exception {
        super.setUp();
        if (this.context != null) {
            this.context.stop();
        }
        ClassPathXmlApplicationContext c = new ClassPathXmlApplicationContext("org/apache/camel/spring/config/scan/componentScan.xml");
        this.context = (CamelContext)c.getBean("camelScan");
        this.template = this.context.createProducerTemplate();
        this.template.start();
    }

    protected void tearDown() throws Exception {
        this.template.stop();
        super.tearDown();
    }

    public void testExcludedRoute() throws InterruptedException {
        SpringComponentScanTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        MockEndpoint mock = this.getMockEndpoint("mock:definitelyShouldNeverReceiveExchange");
        mock.expectedMessageCount(0);
        this.sendBody("direct:shouldNeverRecieveExchange", "dropped like a hot rock");
        mock.await(500L, TimeUnit.MILLISECONDS);
        mock.assertIsSatisfied();
    }

    public void testSpringComponentScanFeature() throws InterruptedException {
        this.template.sendBody("direct:start", (Object)"request");
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        mock.assertIsSatisfied();
    }
}

