/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.example;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PojoDualCamelContextConsumerTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;
    private ApplicationContext ac;

    public void testCamel1() throws Exception {
        String body = "<hello>world!</hello>";
        MockEndpoint result = (MockEndpoint)this.camel1.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{body});
        ProducerTemplate template = this.camel1.createProducerTemplate();
        template.start();
        template.sendBody("direct:start", (Object)body);
        template.stop();
        result.assertIsSatisfied();
    }

    public void testCamel2() throws Exception {
        String body = "<bye>world!</bye>";
        MockEndpoint result = (MockEndpoint)this.camel2.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{body});
        ProducerTemplate template = this.camel2.createProducerTemplate();
        template.start();
        template.sendBody("direct:start", (Object)body);
        template.stop();
        result.assertIsSatisfied();
    }

    public void testCamel1RecipientList() throws Exception {
        String body = "<hello>world!</hello>";
        MockEndpoint result = (MockEndpoint)this.camel1.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedMessageCount(0);
        ProducerTemplate template = this.camel1.createProducerTemplate();
        template.start();
        template.sendBody("seda:foo", (Object)body);
        template.stop();
        Thread.sleep(200L);
        result.assertIsSatisfied();
    }

    public void testCamel2RecipientList() throws Exception {
        String body = "<bye>world!</bye>";
        MockEndpoint result = (MockEndpoint)this.camel2.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{body});
        MockEndpoint foo = (MockEndpoint)this.camel2.getEndpoint("mock:foo", MockEndpoint.class);
        foo.expectedBodiesReceived(new Object[]{body});
        ProducerTemplate template = this.camel2.createProducerTemplate();
        template.start();
        template.sendBody("direct:foo", (Object)body);
        template.stop();
        result.assertIsSatisfied();
        foo.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ac = new ClassPathXmlApplicationContext("org/apache/camel/spring/example/pojoDualCamelContextConsumer.xml");
        this.camel1 = (CamelContext)this.ac.getBean("camel-1");
        this.camel2 = (CamelContext)this.ac.getBean("camel-2");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.camel1.stop();
        this.camel2.stop();
    }
}

