/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.example;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.example.MySender;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PojoSenderTest
extends SpringTestSupport {
    protected MockEndpoint matchedEndpoint;
    protected MockEndpoint notMatchedEndpoint;
    protected MySender mySender;

    public void testMatchesPredicate() throws Exception {
        this.matchedEndpoint.expectedMessageCount(1);
        this.notMatchedEndpoint.expectedMessageCount(0);
        this.mySender.doSomething("James");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.matchedEndpoint, this.notMatchedEndpoint});
    }

    public void testDoesNotMatchPredicate() throws Exception {
        this.matchedEndpoint.expectedMessageCount(0);
        this.notMatchedEndpoint.expectedMessageCount(1);
        this.mySender.doSomething("Rob");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.matchedEndpoint, this.notMatchedEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.matchedEndpoint = this.getMockEndpoint("mock:a");
        this.notMatchedEndpoint = this.getMockEndpoint("mock:b");
        this.mySender = this.getMandatoryBean(MySender.class, "mySender");
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/example/pojoSender.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }
}

