/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.file;

import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class SpringFileAntPathMatcherFileFilterTest
extends AbstractJUnit38SpringContextTests {
    protected String expectedBody = "Godday World";
    @Autowired
    protected ProducerTemplate template;
    @EndpointInject(ref="myFileEndpoint")
    protected Endpoint inputFile;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    public void testAntPatchMatherFilter() throws Exception {
        this.result.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBodyAndHeader(this.inputFile, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.inputFile, (Object)"Bye World", "CamelFileName", (Object)"bye.xml");
        this.template.sendBodyAndHeader(this.inputFile, (Object)this.expectedBody, "CamelFileName", (Object)"subfolder/foo/godday.txt");
        this.template.sendBodyAndHeader(this.inputFile, (Object)"Bad world", "CamelFileName", (Object)"subfolder/badday.txt");
        this.template.sendBodyAndHeader(this.inputFile, (Object)"Day world", "CamelFileName", (Object)"day.xml");
        this.result.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        TestSupport.deleteDirectory((String)"target/antpathmatcher");
        super.setUp();
    }
}

