/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.file;

import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringFileLanguageCBRTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/file/SpringFileLanguageCBRTest.xml");
    }

    @Override
    protected void setUp() throws Exception {
        SpringFileLanguageCBRTest.deleteDirectory((String)"target/cbr");
        super.setUp();
    }

    public void testTxt() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(1);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testDat() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Bye World", "CamelFileName", (Object)"bye.dat");
        this.assertMockEndpointsSatisfied();
    }

    public void testOther() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hi World", "CamelFileName", (Object)"hi.foo");
        this.assertMockEndpointsSatisfied();
    }
}

