/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.file;

import java.io.File;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TestSupport;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class SpringFileRouteTest
extends AbstractJUnit38SpringContextTests {
    protected String expectedBody = "Hello World!";
    @Autowired
    protected ProducerTemplate template;
    @Autowired
    protected Endpoint inputFile;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    public void testMocksAreValid() throws Exception {
        FileEndpoint fileEndpoint = (FileEndpoint)TestSupport.assertIsInstanceOf(FileEndpoint.class, (Object)this.inputFile);
        SpringFileRouteTest.assertEquals((String)"File", (Object)new File("target/test-default-inbox"), (Object)fileEndpoint.getFile());
        this.result.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.result.setResultWaitTime(5000L);
        this.template.sendBodyAndHeader(this.inputFile, (Object)this.expectedBody, "CamelFileName", (Object)"hello.txt");
        this.result.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        TestSupport.deleteDirectory((String)"target/test-default-inbox");
        super.setUp();
    }
}

