/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import junit.framework.TestCase;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spring.handler.MyErrorProcessor;
import org.apache.camel.spring.spi.TransactionErrorHandlerBuilder;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ErrorHandlerDefinitionParserTest
extends TestCase {
    protected ClassPathXmlApplicationContext ctx;

    public void setUp() throws Exception {
        this.ctx = new ClassPathXmlApplicationContext("org/apache/camel/spring/handler/ErrorHandlerDefinitionParser.xml");
    }

    public void tearDown() throws Exception {
        this.ctx.close();
    }

    public void testLoggingErrorHandler() {
        LoggingErrorHandlerBuilder errorHandler = (LoggingErrorHandlerBuilder)this.ctx.getBean("loggingErrorHandler");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
        ErrorHandlerDefinitionParserTest.assertEquals((String)"The log level should be INFO", (Object)LoggingLevel.INFO, (Object)errorHandler.getLevel());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"The log name should be foo", (String)"foo", (String)errorHandler.getLogName());
    }

    public void testDefaultErrorHandler() {
        DefaultErrorHandlerBuilder errorHandler = (DefaultErrorHandlerBuilder)this.ctx.getBean("defaultErrorHandler");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
        RedeliveryPolicy policy = errorHandler.getRedeliveryPolicy();
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)policy);
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong maximumRedeliveries", (int)2, (int)policy.getMaximumRedeliveries());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong redeliveryDelay", (long)0L, (long)policy.getRedeliveryDelay());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong logStackTrace", (boolean)false, (boolean)policy.isLogStackTrace());
        errorHandler = (DefaultErrorHandlerBuilder)this.ctx.getBean("errorHandler");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
    }

    public void testTransactionErrorHandler() {
        TransactionErrorHandlerBuilder errorHandler = (TransactionErrorHandlerBuilder)this.ctx.getBean("transactionErrorHandler");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler.getTransactionTemplate());
        Processor processor = errorHandler.getOnRedelivery();
        ErrorHandlerDefinitionParserTest.assertTrue((String)"It should be MyErrorProcessor", (boolean)(processor instanceof MyErrorProcessor));
    }

    public void testTXErrorHandler() {
        TransactionErrorHandlerBuilder errorHandler = (TransactionErrorHandlerBuilder)this.ctx.getBean("txEH");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler.getTransactionTemplate());
    }

    public void testDeadLetterErrorHandler() {
        DeadLetterChannelBuilder errorHandler = (DeadLetterChannelBuilder)this.ctx.getBean("deadLetterErrorHandler");
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)errorHandler);
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Get wrong deadletteruri", (String)"log:dead", (String)errorHandler.getDeadLetterUri());
        RedeliveryPolicy policy = errorHandler.getRedeliveryPolicy();
        ErrorHandlerDefinitionParserTest.assertNotNull((Object)policy);
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong maximumRedeliveries", (int)2, (int)policy.getMaximumRedeliveries());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong redeliveryDelay", (long)1000L, (long)policy.getRedeliveryDelay());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong logStackTrace", (boolean)true, (boolean)policy.isLogHandled());
        ErrorHandlerDefinitionParserTest.assertEquals((String)"Wrong asyncRedeliveryDelayed", (boolean)true, (boolean)policy.isAsyncDelayedRedelivery());
    }
}

