/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.interceptor.AnnotatedBookStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class AnnotatedBookServiceImpl
implements AnnotatedBookStore {
    @Autowired
    private DataSource dataSource;
    @EndpointInject(uri="seda:book")
    private ProducerTemplate template;

    @Override
    public void orderBook(String title) throws Exception {
        Transactional tx = this.getClass().getAnnotation(Transactional.class);
        if (tx == null) {
            throw new IllegalStateException("Spring annotation-driven should have instrumented this class as @Transactional");
        }
        if (!"REQUIRED".equals(tx.propagation().name())) {
            throw new IllegalStateException("Should be REQUIRED propagation");
        }
        if (title.startsWith("Donkey")) {
            throw new IllegalArgumentException("We don't have Donkeys, only Camels");
        }
        new SimpleJdbcTemplate(this.dataSource).update("insert into books (title) values (?)", new Object[]{title});
        this.template.sendBody((Object)title);
    }
}

