/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Consume;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.interceptor.AnnotatedConsume;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.NEVER, readOnly=true)
public class AnnotatedConsumeImpl
implements AnnotatedConsume {
    @Produce(uri="mock:book")
    ProducerTemplate producer;

    @Override
    @Consume(uri="seda:book")
    public void handleTitle(String title) {
        Transactional tx = this.getClass().getAnnotation(Transactional.class);
        if (tx == null) {
            throw new IllegalStateException("Spring annotation-driven should have instrumented this class as @Transactional");
        }
        if (!"NEVER".equals(tx.propagation().name())) {
            throw new IllegalStateException("Should be NEVER propagation");
        }
        if (!tx.readOnly()) {
            throw new IllegalStateException("Should be read only");
        }
        if (!title.contains("in Action")) {
            throw new IllegalArgumentException("Not a book title we like");
        }
        this.producer.sendBody((Object)title);
    }
}

