/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerWideInterceptor
implements InterceptStrategy {
    private static final transient Logger LOG = LoggerFactory.getLogger(ContainerWideInterceptor.class);
    private static int count;

    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition definition, final Processor target, Processor nextTarget) throws Exception {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                count++;
                LOG.info("I am the container wide interceptor. Intercepted total count: " + count);
                target.process(exchange);
            }

            public String toString() {
                return "ContainerWideInterceptor[" + target + "]";
            }
        };
    }

    public int getCount() {
        return count;
    }
}

