/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.interceptor.ContainerWideInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ContainerWideInterceptorTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;
    private ApplicationContext ac;
    private ContainerWideInterceptor myInterceptor;

    protected void setUp() throws Exception {
        super.setUp();
        this.ac = new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/ContainerWideInterceptorTest.xml");
        this.camel1 = (CamelContext)this.ac.getBean("camel1");
        this.camel2 = (CamelContext)this.ac.getBean("camel2");
        this.myInterceptor = (ContainerWideInterceptor)this.ac.getBean("myInterceptor");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.camel2.stop();
        this.camel1.stop();
    }

    public void testOne() throws Exception {
        int start = this.myInterceptor.getCount();
        MockEndpoint result = (MockEndpoint)this.camel1.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{"Hello World"});
        ProducerTemplate template = this.camel1.createProducerTemplate();
        template.start();
        template.sendBody("direct:one", (Object)"Hello World");
        template.stop();
        result.assertIsSatisfied();
        int delta = this.myInterceptor.getCount() - start;
        ContainerWideInterceptorTest.assertEquals((String)"Should have been counted +1", (int)1, (int)delta);
    }

    public void testTwo() throws Exception {
        int start = this.myInterceptor.getCount();
        MockEndpoint result = (MockEndpoint)this.camel2.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{"Bye World"});
        ProducerTemplate template = this.camel2.createProducerTemplate();
        template.start();
        template.sendBody("direct:two", (Object)"Bye World");
        template.stop();
        result.assertIsSatisfied();
        int delta = this.myInterceptor.getCount() - start;
        ContainerWideInterceptorTest.assertEquals((String)"Should have been counted +2", (int)2, (int)delta);
    }
}

