/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DelayerInterceptorTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/delayerInterceptorTest.xml");
    }

    public void testDelayer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(10);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message #" + i));
        }
        long delta = System.currentTimeMillis() - start + 200L;
        this.assertMockEndpointsSatisfied();
        DelayerInterceptorTest.assertTrue((String)("Should be slower to run: " + delta), (delta >= 2000L ? 1 : 0) != 0);
        DelayerInterceptorTest.assertTrue((String)("Should not take that long to run: " + delta), (delta <= 7000L ? 1 : 0) != 0);
    }
}

