/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class MixedPropagationTransactedTest
extends SpringTestSupport {
    protected SimpleJdbcTemplate jdbc;
    protected boolean useTransactionErrorHandler = true;

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/mixedPropagationTransactedTest.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new SimpleJdbcTemplate(ds);
        this.jdbc.getJdbcOperations().execute("create table books (title varchar(50))");
        this.jdbc.update("insert into books (title) values (?)", new Object[]{"Camel in Action"});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbc.getJdbcOperations().execute("drop table books");
    }

    public void testRequiredOnly() throws Exception {
        this.template.sendBody("direct:required", (Object)"Tiger in Action");
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Tiger in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    public void testRequired2Only() throws Exception {
        this.template.sendBody("direct:required2", (Object)"Tiger in Action");
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)2, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Tiger in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testRequiresNewOnly() throws Exception {
        this.template.sendBody("direct:new", (Object)"Elephant in Action");
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Elephant in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    public void testRequiredAndRequiresNew() throws Exception {
        this.template.sendBody("direct:requiredAndNew", (Object)"Tiger in Action");
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)2, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Tiger in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testRequiredOnlkyRollback() throws Exception {
        try {
            this.template.sendBody("direct:required", (Object)"Donkey in Action");
        }
        catch (RuntimeCamelException e) {
            MixedPropagationTransactedTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            MixedPropagationTransactedTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            MixedPropagationTransactedTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)0, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Donkey in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    public void testRequiresNewOnlkyRollback() throws Exception {
        try {
            this.template.sendBody("direct:new", (Object)"Donkey in Action");
        }
        catch (RuntimeCamelException e) {
            MixedPropagationTransactedTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            MixedPropagationTransactedTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            MixedPropagationTransactedTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)0, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Donkey in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    public void testRequiredAndNewRollback() throws Exception {
        try {
            this.template.sendBody("direct:new", (Object)"Tiger in Action");
        }
        catch (RuntimeCamelException e) {
            MixedPropagationTransactedTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            MixedPropagationTransactedTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            MixedPropagationTransactedTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books", new Object[0]);
        MixedPropagationTransactedTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Tiger in Action"}));
        MixedPropagationTransactedTest.assertEquals((int)0, (int)this.jdbc.queryForInt("select count(*) from books where title = ?", new Object[]{"Donkey in Action"}));
        MixedPropagationTransactedTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:required").transacted("PROPATATION_REQUIRED").beanRef("bookService");
                ((PolicyDefinition)this.from("direct:required2").transacted("PROPATATION_REQUIRED").beanRef("bookService")).beanRef("bookService");
                this.from("direct:new").transacted("PROPAGATION_REQUIRES_NEW").beanRef("bookService");
                this.from("direct:requiredAndNew").to(new String[]{"direct:required", "direct:new"});
                ((RouteDefinition)((RouteDefinition)this.from("direct:requiredAndNewRollback").to("direct:required")).setBody((Expression)this.constant("Donkey in Action"))).to("direct:new");
            }
        };
    }
}

