/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class MixedStreamCachingInterceptorTest
extends ContextTestSupport {
    public void testStreamCaching() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader("<hello>world!</hello>"));
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)a.getExchanges().get(0);
        StreamCache cache = (StreamCache)MixedStreamCachingInterceptorTest.assertIsInstanceOf(StreamCache.class, (Object)exchange.getIn().getBody());
        MixedStreamCachingInterceptorTest.assertNotNull((Object)cache);
        MixedStreamCachingInterceptorTest.assertNotSame((Object)message, (Object)cache);
    }

    public void testNoStreamCaching() throws Exception {
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader("<hello>world!</hello>"));
        this.template.sendBody("direct:b", (Object)message);
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)b.getExchanges().get(0);
        StreamSource stream = (StreamSource)MixedStreamCachingInterceptorTest.assertIsInstanceOf(StreamSource.class, (Object)exchange.getIn().getBody());
        MixedStreamCachingInterceptorTest.assertNotNull((Object)stream);
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/interceptor/mixedStreamCachingInterceptorTest.xml");
    }
}

