/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class MixedTransactionPropagationTest
extends SpringTestSupport {
    protected JdbcTemplate jdbc;

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/MixedTransactionPropagationTest.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected void setUp() throws Exception {
        this.disableJMX();
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new JdbcTemplate(ds);
        this.jdbc.execute("create table books (title varchar(50))");
        this.jdbc.update("insert into books (title) values (?)", new Object[]{"Camel in Action"});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbc.execute("drop table books");
        this.enableJMX();
    }

    public void testOkay() throws Exception {
        this.template.sendBody("direct:okay", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        MixedTransactionPropagationTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testFail() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            MixedTransactionPropagationTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            MixedTransactionPropagationTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            MixedTransactionPropagationTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        MixedTransactionPropagationTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    public void testMixedRollbackOnlyLast() throws Exception {
        this.template.sendBody("direct:mixed", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        MixedTransactionPropagationTest.assertEquals((String)"Number of books", (int)3, (int)count);
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Camel in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Tiger in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Elephant in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)0, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Lion in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)0, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Donkey in Action'"));
    }

    public void testMixedCommit() throws Exception {
        this.template.sendBody("direct:mixed3", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        MixedTransactionPropagationTest.assertEquals((String)"Number of books", (int)5, (int)count);
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Camel in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Tiger in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Elephant in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Lion in Action'"));
        MixedTransactionPropagationTest.assertEquals((int)1, (int)this.jdbc.queryForInt("select count(*) from books where title = 'Crocodile in Action'"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted("PROPAGATION_REQUIRED").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").transacted("PROPAGATION_REQUIRED").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:mixed").transacted("PROPAGATION_REQUIRED").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService")).to("direct:mixed2");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((OnExceptionDefinition)this.from("direct:mixed2").onException(Exception.class).markRollbackOnlyLast()).end().transacted("PROPAGATION_REQUIRES_NEW").setBody((Expression)this.constant("Lion in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:mixed3").transacted("PROPAGATION_REQUIRED").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService")).to("direct:mixed4");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((OnExceptionDefinition)this.from("direct:mixed4").onException(Exception.class).markRollbackOnlyLast()).end().transacted("PROPAGATION_REQUIRES_NEW").setBody((Expression)this.constant("Lion in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Crocodile in Action"))).beanRef("bookService");
            }
        };
    }
}

