/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;

public class TransactedInterceptSendToEndpointTest
extends TransactionalClientDataSourceTest {
    @Override
    public void testTransactionSuccess() throws Exception {
        MockEndpoint intercepted = this.getMockEndpoint("mock:intercepted");
        intercepted.expectedBodiesReceived(new Object[]{"Hello World"});
        super.testTransactionSuccess();
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public void testTransactionRollback() throws Exception {
        MockEndpoint intercepted = this.getMockEndpoint("mock:intercepted");
        intercepted.expectedBodiesReceived(new Object[]{"Tiger in Action"});
        super.testTransactionRollback();
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("direct:(foo|bar)").to("mock:intercepted");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted().to("direct:foo")).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).to("direct:bar")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
                this.from("direct:foo").to("log:okay");
                this.from("direct:bar").to("mock:fail");
            }
        };
    }
}

