/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class TransactionClientDataSourceSupport
extends SpringTestSupport {
    protected JdbcTemplate jdbc;
    protected boolean useTransactionErrorHandler = true;

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/transactionalClientDataSource.xml");
    }

    @Override
    protected void setUp() throws Exception {
        this.disableJMX();
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new JdbcTemplate(ds);
        this.jdbc.execute("create table books (title varchar(50))");
        this.jdbc.update("insert into books (title) values (?)", new Object[]{"Camel in Action"});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbc.execute("drop table books");
        this.enableJMX();
    }

    public boolean isUseTransactionErrorHandler() {
        return this.useTransactionErrorHandler;
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }
}

