/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceWithOnExceptionTest;

public class TransactionalClientDataSourceHandledTest
extends TransactionalClientDataSourceWithOnExceptionTest {
    @Override
    public void testTransactionRollback() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:fail", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceHandledTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:error");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

