/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class TransactionalClientDataSourceMinimalConfigurationTest
extends SpringTestSupport {
    protected JdbcTemplate jdbc;

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/springTransactionalClientDataSourceMinimalConfiguration.xml");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new JdbcTemplate(ds);
        this.jdbc.execute("create table books (title varchar(50))");
        this.jdbc.update("insert into books (title) values (?)", new Object[]{"Camel in Action"});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbc.execute("drop table books");
    }

    public void testTransactionSuccess() throws Exception {
        this.template.sendBody("direct:okay", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceMinimalConfigurationTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testTransactionRollback() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientDataSourceMinimalConfigurationTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            TransactionalClientDataSourceMinimalConfigurationTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            TransactionalClientDataSourceMinimalConfigurationTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceMinimalConfigurationTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }
}

