/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;

public class TransactionalClientDataSourceMixedTransactedTest
extends TransactionalClientDataSourceTest {
    @Override
    public void testTransactionRollback() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientDataSourceMixedTransactedTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            TransactionalClientDataSourceMixedTransactedTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceMixedTransactedTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).onWhen(this.exceptionMessage().contains((Object)"Donkey")).handled(true);
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:fail").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

