/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;

public class TransactionalClientDataSourceNotTransactedTest
extends TransactionalClientDataSourceTest {
    @Override
    public void testTransactionRollback() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientDataSourceNotTransactedTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            TransactionalClientDataSourceNotTransactedTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceNotTransactedTest.assertEquals((String)"Number of books", (int)2, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:okay").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:fail").setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

