/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;

public class TransactionalClientDataSourceOnExceptionRedeliveryTest
extends TransactionalClientDataSourceTest {
    public void testTransactionRollbackWithExchange() throws Exception {
        Exchange out = this.template.send("direct:fail", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((String)"Number of books", (int)1, (int)count);
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertNotNull((Object)out);
        Exception e = out.getException();
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e);
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getMessage());
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((Object)true, (Object)out.getIn().getHeader("CamelRedelivered"));
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((Object)3, (Object)out.getIn().getHeader("CamelRedeliveryCounter"));
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((Object)true, (Object)out.getProperty("CamelFailureHandled"));
        TransactionalClientDataSourceOnExceptionRedeliveryTest.assertEquals((Object)false, (Object)out.getProperty("CamelErrorHandlerHandled"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3);
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

