/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionClientDataSourceSupport;
import org.apache.camel.spring.spi.SpringTransactionPolicy;

public class TransactionalClientDataSourceTest
extends TransactionClientDataSourceSupport {
    public void testTransactionSuccess() throws Exception {
        this.template.sendBody("direct:okay", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testTransactionRollback() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientDataSourceTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            TransactionalClientDataSourceTest.assertTrue((boolean)(e.getCause().getCause() instanceof IllegalArgumentException));
            TransactionalClientDataSourceTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                SpringTransactionPolicy required = (SpringTransactionPolicy)this.lookup("PROPAGATION_REQUIRED", SpringTransactionPolicy.class);
                if (TransactionalClientDataSourceTest.this.isUseTransactionErrorHandler()) {
                    this.errorHandler((ErrorHandlerBuilder)this.transactionErrorHandler(required));
                }
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

